import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeMovingAddressesRequest, DescribeMovingAddressesResult } from "../models/models_3";
import { deserializeAws_ec2DescribeMovingAddressesCommand, serializeAws_ec2DescribeMovingAddressesCommand, } from "../protocols/Aws_ec2";
var DescribeMovingAddressesCommand = (function (_super) {
    __extends(DescribeMovingAddressesCommand, _super);
    function DescribeMovingAddressesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeMovingAddressesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeMovingAddressesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeMovingAddressesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeMovingAddressesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeMovingAddressesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeMovingAddressesCommand(input, context);
    };
    DescribeMovingAddressesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeMovingAddressesCommand(output, context);
    };
    return DescribeMovingAddressesCommand;
}($Command));
export { DescribeMovingAddressesCommand };
