import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeManagedPrefixListsRequest, DescribeManagedPrefixListsResult } from "../models/models_3";
import { deserializeAws_ec2DescribeManagedPrefixListsCommand, serializeAws_ec2DescribeManagedPrefixListsCommand, } from "../protocols/Aws_ec2";
var DescribeManagedPrefixListsCommand = (function (_super) {
    __extends(DescribeManagedPrefixListsCommand, _super);
    function DescribeManagedPrefixListsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeManagedPrefixListsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeManagedPrefixListsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeManagedPrefixListsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeManagedPrefixListsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeManagedPrefixListsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeManagedPrefixListsCommand(input, context);
    };
    DescribeManagedPrefixListsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeManagedPrefixListsCommand(output, context);
    };
    return DescribeManagedPrefixListsCommand;
}($Command));
export { DescribeManagedPrefixListsCommand };
