import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeLocalGatewaysRequest, DescribeLocalGatewaysResult } from "../models/models_3";
import { deserializeAws_ec2DescribeLocalGatewaysCommand, serializeAws_ec2DescribeLocalGatewaysCommand, } from "../protocols/Aws_ec2";
var DescribeLocalGatewaysCommand = (function (_super) {
    __extends(DescribeLocalGatewaysCommand, _super);
    function DescribeLocalGatewaysCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeLocalGatewaysCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeLocalGatewaysCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeLocalGatewaysRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeLocalGatewaysResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeLocalGatewaysCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeLocalGatewaysCommand(input, context);
    };
    DescribeLocalGatewaysCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeLocalGatewaysCommand(output, context);
    };
    return DescribeLocalGatewaysCommand;
}($Command));
export { DescribeLocalGatewaysCommand };
