import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeLocalGatewayRouteTablesRequest, DescribeLocalGatewayRouteTablesResult } from "../models/models_3";
import { deserializeAws_ec2DescribeLocalGatewayRouteTablesCommand, serializeAws_ec2DescribeLocalGatewayRouteTablesCommand, } from "../protocols/Aws_ec2";
var DescribeLocalGatewayRouteTablesCommand = (function (_super) {
    __extends(DescribeLocalGatewayRouteTablesCommand, _super);
    function DescribeLocalGatewayRouteTablesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeLocalGatewayRouteTablesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeLocalGatewayRouteTablesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeLocalGatewayRouteTablesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeLocalGatewayRouteTablesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeLocalGatewayRouteTablesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeLocalGatewayRouteTablesCommand(input, context);
    };
    DescribeLocalGatewayRouteTablesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeLocalGatewayRouteTablesCommand(output, context);
    };
    return DescribeLocalGatewayRouteTablesCommand;
}($Command));
export { DescribeLocalGatewayRouteTablesCommand };
