import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeLocalGatewayRouteTableVpcAssociationsRequest, DescribeLocalGatewayRouteTableVpcAssociationsResult, } from "../models/models_3";
import { deserializeAws_ec2DescribeLocalGatewayRouteTableVpcAssociationsCommand, serializeAws_ec2DescribeLocalGatewayRouteTableVpcAssociationsCommand, } from "../protocols/Aws_ec2";
var DescribeLocalGatewayRouteTableVpcAssociationsCommand = (function (_super) {
    __extends(DescribeLocalGatewayRouteTableVpcAssociationsCommand, _super);
    function DescribeLocalGatewayRouteTableVpcAssociationsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeLocalGatewayRouteTableVpcAssociationsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeLocalGatewayRouteTableVpcAssociationsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeLocalGatewayRouteTableVpcAssociationsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeLocalGatewayRouteTableVpcAssociationsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeLocalGatewayRouteTableVpcAssociationsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeLocalGatewayRouteTableVpcAssociationsCommand(input, context);
    };
    DescribeLocalGatewayRouteTableVpcAssociationsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeLocalGatewayRouteTableVpcAssociationsCommand(output, context);
    };
    return DescribeLocalGatewayRouteTableVpcAssociationsCommand;
}($Command));
export { DescribeLocalGatewayRouteTableVpcAssociationsCommand };
