import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeLaunchTemplatesRequest, DescribeLaunchTemplatesResult } from "../models/models_3";
import { deserializeAws_ec2DescribeLaunchTemplatesCommand, serializeAws_ec2DescribeLaunchTemplatesCommand, } from "../protocols/Aws_ec2";
var DescribeLaunchTemplatesCommand = (function (_super) {
    __extends(DescribeLaunchTemplatesCommand, _super);
    function DescribeLaunchTemplatesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeLaunchTemplatesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeLaunchTemplatesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeLaunchTemplatesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeLaunchTemplatesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeLaunchTemplatesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeLaunchTemplatesCommand(input, context);
    };
    DescribeLaunchTemplatesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeLaunchTemplatesCommand(output, context);
    };
    return DescribeLaunchTemplatesCommand;
}($Command));
export { DescribeLaunchTemplatesCommand };
