import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeIpv6PoolsRequest, DescribeIpv6PoolsResult } from "../models/models_3";
import { deserializeAws_ec2DescribeIpv6PoolsCommand, serializeAws_ec2DescribeIpv6PoolsCommand, } from "../protocols/Aws_ec2";
var DescribeIpv6PoolsCommand = (function (_super) {
    __extends(DescribeIpv6PoolsCommand, _super);
    function DescribeIpv6PoolsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeIpv6PoolsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeIpv6PoolsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeIpv6PoolsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeIpv6PoolsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeIpv6PoolsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeIpv6PoolsCommand(input, context);
    };
    DescribeIpv6PoolsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeIpv6PoolsCommand(output, context);
    };
    return DescribeIpv6PoolsCommand;
}($Command));
export { DescribeIpv6PoolsCommand };
