import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeIpamScopesRequest, DescribeIpamScopesResult } from "../models/models_3";
import { deserializeAws_ec2DescribeIpamScopesCommand, serializeAws_ec2DescribeIpamScopesCommand, } from "../protocols/Aws_ec2";
var DescribeIpamScopesCommand = (function (_super) {
    __extends(DescribeIpamScopesCommand, _super);
    function DescribeIpamScopesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeIpamScopesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeIpamScopesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeIpamScopesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeIpamScopesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeIpamScopesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeIpamScopesCommand(input, context);
    };
    DescribeIpamScopesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeIpamScopesCommand(output, context);
    };
    return DescribeIpamScopesCommand;
}($Command));
export { DescribeIpamScopesCommand };
