import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeInstanceEventWindowsRequest, DescribeInstanceEventWindowsResult } from "../models/models_3";
import { deserializeAws_ec2DescribeInstanceEventWindowsCommand, serializeAws_ec2DescribeInstanceEventWindowsCommand, } from "../protocols/Aws_ec2";
var DescribeInstanceEventWindowsCommand = (function (_super) {
    __extends(DescribeInstanceEventWindowsCommand, _super);
    function DescribeInstanceEventWindowsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeInstanceEventWindowsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeInstanceEventWindowsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeInstanceEventWindowsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeInstanceEventWindowsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeInstanceEventWindowsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeInstanceEventWindowsCommand(input, context);
    };
    DescribeInstanceEventWindowsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeInstanceEventWindowsCommand(output, context);
    };
    return DescribeInstanceEventWindowsCommand;
}($Command));
export { DescribeInstanceEventWindowsCommand };
