import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeIdentityIdFormatRequest, DescribeIdentityIdFormatResult } from "../models/models_3";
import { deserializeAws_ec2DescribeIdentityIdFormatCommand, serializeAws_ec2DescribeIdentityIdFormatCommand, } from "../protocols/Aws_ec2";
var DescribeIdentityIdFormatCommand = (function (_super) {
    __extends(DescribeIdentityIdFormatCommand, _super);
    function DescribeIdentityIdFormatCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeIdentityIdFormatCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeIdentityIdFormatCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeIdentityIdFormatRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeIdentityIdFormatResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeIdentityIdFormatCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeIdentityIdFormatCommand(input, context);
    };
    DescribeIdentityIdFormatCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeIdentityIdFormatCommand(output, context);
    };
    return DescribeIdentityIdFormatCommand;
}($Command));
export { DescribeIdentityIdFormatCommand };
