import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeHostReservationsRequest, DescribeHostReservationsResult } from "../models/models_3";
import { deserializeAws_ec2DescribeHostReservationsCommand, serializeAws_ec2DescribeHostReservationsCommand, } from "../protocols/Aws_ec2";
var DescribeHostReservationsCommand = (function (_super) {
    __extends(DescribeHostReservationsCommand, _super);
    function DescribeHostReservationsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeHostReservationsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeHostReservationsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeHostReservationsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeHostReservationsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeHostReservationsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeHostReservationsCommand(input, context);
    };
    DescribeHostReservationsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeHostReservationsCommand(output, context);
    };
    return DescribeHostReservationsCommand;
}($Command));
export { DescribeHostReservationsCommand };
