import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeFpgaImagesRequest, DescribeFpgaImagesResult } from "../models/models_3";
import { deserializeAws_ec2DescribeFpgaImagesCommand, serializeAws_ec2DescribeFpgaImagesCommand, } from "../protocols/Aws_ec2";
var DescribeFpgaImagesCommand = (function (_super) {
    __extends(DescribeFpgaImagesCommand, _super);
    function DescribeFpgaImagesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeFpgaImagesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeFpgaImagesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeFpgaImagesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeFpgaImagesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeFpgaImagesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeFpgaImagesCommand(input, context);
    };
    DescribeFpgaImagesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeFpgaImagesCommand(output, context);
    };
    return DescribeFpgaImagesCommand;
}($Command));
export { DescribeFpgaImagesCommand };
