import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeFpgaImageAttributeRequest, DescribeFpgaImageAttributeResult } from "../models/models_3";
import { deserializeAws_ec2DescribeFpgaImageAttributeCommand, serializeAws_ec2DescribeFpgaImageAttributeCommand, } from "../protocols/Aws_ec2";
var DescribeFpgaImageAttributeCommand = (function (_super) {
    __extends(DescribeFpgaImageAttributeCommand, _super);
    function DescribeFpgaImageAttributeCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeFpgaImageAttributeCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeFpgaImageAttributeCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeFpgaImageAttributeRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeFpgaImageAttributeResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeFpgaImageAttributeCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeFpgaImageAttributeCommand(input, context);
    };
    DescribeFpgaImageAttributeCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeFpgaImageAttributeCommand(output, context);
    };
    return DescribeFpgaImageAttributeCommand;
}($Command));
export { DescribeFpgaImageAttributeCommand };
