import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeFleetHistoryRequest, DescribeFleetHistoryResult } from "../models/models_3";
import { deserializeAws_ec2DescribeFleetHistoryCommand, serializeAws_ec2DescribeFleetHistoryCommand, } from "../protocols/Aws_ec2";
var DescribeFleetHistoryCommand = (function (_super) {
    __extends(DescribeFleetHistoryCommand, _super);
    function DescribeFleetHistoryCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeFleetHistoryCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeFleetHistoryCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeFleetHistoryRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeFleetHistoryResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeFleetHistoryCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeFleetHistoryCommand(input, context);
    };
    DescribeFleetHistoryCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeFleetHistoryCommand(output, context);
    };
    return DescribeFleetHistoryCommand;
}($Command));
export { DescribeFleetHistoryCommand };
