import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeFastSnapshotRestoresRequest, DescribeFastSnapshotRestoresResult } from "../models/models_3";
import { deserializeAws_ec2DescribeFastSnapshotRestoresCommand, serializeAws_ec2DescribeFastSnapshotRestoresCommand, } from "../protocols/Aws_ec2";
var DescribeFastSnapshotRestoresCommand = (function (_super) {
    __extends(DescribeFastSnapshotRestoresCommand, _super);
    function DescribeFastSnapshotRestoresCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeFastSnapshotRestoresCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeFastSnapshotRestoresCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeFastSnapshotRestoresRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeFastSnapshotRestoresResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeFastSnapshotRestoresCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeFastSnapshotRestoresCommand(input, context);
    };
    DescribeFastSnapshotRestoresCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeFastSnapshotRestoresCommand(output, context);
    };
    return DescribeFastSnapshotRestoresCommand;
}($Command));
export { DescribeFastSnapshotRestoresCommand };
