import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeCustomerGatewaysRequest, DescribeCustomerGatewaysResult } from "../models/models_3";
import { deserializeAws_ec2DescribeCustomerGatewaysCommand, serializeAws_ec2DescribeCustomerGatewaysCommand, } from "../protocols/Aws_ec2";
var DescribeCustomerGatewaysCommand = (function (_super) {
    __extends(DescribeCustomerGatewaysCommand, _super);
    function DescribeCustomerGatewaysCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeCustomerGatewaysCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeCustomerGatewaysCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeCustomerGatewaysRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeCustomerGatewaysResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeCustomerGatewaysCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeCustomerGatewaysCommand(input, context);
    };
    DescribeCustomerGatewaysCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeCustomerGatewaysCommand(output, context);
    };
    return DescribeCustomerGatewaysCommand;
}($Command));
export { DescribeCustomerGatewaysCommand };
