import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeCoipPoolsRequest, DescribeCoipPoolsResult } from "../models/models_2";
import { deserializeAws_ec2DescribeCoipPoolsCommand, serializeAws_ec2DescribeCoipPoolsCommand, } from "../protocols/Aws_ec2";
var DescribeCoipPoolsCommand = (function (_super) {
    __extends(DescribeCoipPoolsCommand, _super);
    function DescribeCoipPoolsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeCoipPoolsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeCoipPoolsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeCoipPoolsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeCoipPoolsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeCoipPoolsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeCoipPoolsCommand(input, context);
    };
    DescribeCoipPoolsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeCoipPoolsCommand(output, context);
    };
    return DescribeCoipPoolsCommand;
}($Command));
export { DescribeCoipPoolsCommand };
