import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeClientVpnRoutesRequest, DescribeClientVpnRoutesResult } from "../models/models_2";
import { deserializeAws_ec2DescribeClientVpnRoutesCommand, serializeAws_ec2DescribeClientVpnRoutesCommand, } from "../protocols/Aws_ec2";
var DescribeClientVpnRoutesCommand = (function (_super) {
    __extends(DescribeClientVpnRoutesCommand, _super);
    function DescribeClientVpnRoutesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeClientVpnRoutesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeClientVpnRoutesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeClientVpnRoutesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeClientVpnRoutesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeClientVpnRoutesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeClientVpnRoutesCommand(input, context);
    };
    DescribeClientVpnRoutesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeClientVpnRoutesCommand(output, context);
    };
    return DescribeClientVpnRoutesCommand;
}($Command));
export { DescribeClientVpnRoutesCommand };
