import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeClientVpnConnectionsRequest, DescribeClientVpnConnectionsResult } from "../models/models_2";
import { deserializeAws_ec2DescribeClientVpnConnectionsCommand, serializeAws_ec2DescribeClientVpnConnectionsCommand, } from "../protocols/Aws_ec2";
var DescribeClientVpnConnectionsCommand = (function (_super) {
    __extends(DescribeClientVpnConnectionsCommand, _super);
    function DescribeClientVpnConnectionsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeClientVpnConnectionsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeClientVpnConnectionsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeClientVpnConnectionsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeClientVpnConnectionsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeClientVpnConnectionsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeClientVpnConnectionsCommand(input, context);
    };
    DescribeClientVpnConnectionsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeClientVpnConnectionsCommand(output, context);
    };
    return DescribeClientVpnConnectionsCommand;
}($Command));
export { DescribeClientVpnConnectionsCommand };
