import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeCarrierGatewaysRequest, DescribeCarrierGatewaysResult } from "../models/models_2";
import { deserializeAws_ec2DescribeCarrierGatewaysCommand, serializeAws_ec2DescribeCarrierGatewaysCommand, } from "../protocols/Aws_ec2";
var DescribeCarrierGatewaysCommand = (function (_super) {
    __extends(DescribeCarrierGatewaysCommand, _super);
    function DescribeCarrierGatewaysCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeCarrierGatewaysCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeCarrierGatewaysCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeCarrierGatewaysRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeCarrierGatewaysResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeCarrierGatewaysCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeCarrierGatewaysCommand(input, context);
    };
    DescribeCarrierGatewaysCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeCarrierGatewaysCommand(output, context);
    };
    return DescribeCarrierGatewaysCommand;
}($Command));
export { DescribeCarrierGatewaysCommand };
