import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeCapacityReservationsRequest, DescribeCapacityReservationsResult } from "../models/models_2";
import { deserializeAws_ec2DescribeCapacityReservationsCommand, serializeAws_ec2DescribeCapacityReservationsCommand, } from "../protocols/Aws_ec2";
var DescribeCapacityReservationsCommand = (function (_super) {
    __extends(DescribeCapacityReservationsCommand, _super);
    function DescribeCapacityReservationsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeCapacityReservationsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeCapacityReservationsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeCapacityReservationsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeCapacityReservationsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeCapacityReservationsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeCapacityReservationsCommand(input, context);
    };
    DescribeCapacityReservationsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeCapacityReservationsCommand(output, context);
    };
    return DescribeCapacityReservationsCommand;
}($Command));
export { DescribeCapacityReservationsCommand };
