import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeBundleTasksRequest, DescribeBundleTasksResult } from "../models/models_2";
import { deserializeAws_ec2DescribeBundleTasksCommand, serializeAws_ec2DescribeBundleTasksCommand, } from "../protocols/Aws_ec2";
var DescribeBundleTasksCommand = (function (_super) {
    __extends(DescribeBundleTasksCommand, _super);
    function DescribeBundleTasksCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeBundleTasksCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeBundleTasksCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeBundleTasksRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeBundleTasksResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeBundleTasksCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeBundleTasksCommand(input, context);
    };
    DescribeBundleTasksCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeBundleTasksCommand(output, context);
    };
    return DescribeBundleTasksCommand;
}($Command));
export { DescribeBundleTasksCommand };
