import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeAggregateIdFormatRequest, DescribeAggregateIdFormatResult } from "../models/models_2";
import { deserializeAws_ec2DescribeAggregateIdFormatCommand, serializeAws_ec2DescribeAggregateIdFormatCommand, } from "../protocols/Aws_ec2";
var DescribeAggregateIdFormatCommand = (function (_super) {
    __extends(DescribeAggregateIdFormatCommand, _super);
    function DescribeAggregateIdFormatCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeAggregateIdFormatCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeAggregateIdFormatCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeAggregateIdFormatRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeAggregateIdFormatResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeAggregateIdFormatCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeAggregateIdFormatCommand(input, context);
    };
    DescribeAggregateIdFormatCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeAggregateIdFormatCommand(output, context);
    };
    return DescribeAggregateIdFormatCommand;
}($Command));
export { DescribeAggregateIdFormatCommand };
