import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeAccountAttributesRequest, DescribeAccountAttributesResult } from "../models/models_2";
import { deserializeAws_ec2DescribeAccountAttributesCommand, serializeAws_ec2DescribeAccountAttributesCommand, } from "../protocols/Aws_ec2";
var DescribeAccountAttributesCommand = (function (_super) {
    __extends(DescribeAccountAttributesCommand, _super);
    function DescribeAccountAttributesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeAccountAttributesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeAccountAttributesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeAccountAttributesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeAccountAttributesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeAccountAttributesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeAccountAttributesCommand(input, context);
    };
    DescribeAccountAttributesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeAccountAttributesCommand(output, context);
    };
    return DescribeAccountAttributesCommand;
}($Command));
export { DescribeAccountAttributesCommand };
