import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeregisterTransitGatewayMulticastGroupSourcesRequest, DeregisterTransitGatewayMulticastGroupSourcesResult, } from "../models/models_2";
import { deserializeAws_ec2DeregisterTransitGatewayMulticastGroupSourcesCommand, serializeAws_ec2DeregisterTransitGatewayMulticastGroupSourcesCommand, } from "../protocols/Aws_ec2";
var DeregisterTransitGatewayMulticastGroupSourcesCommand = (function (_super) {
    __extends(DeregisterTransitGatewayMulticastGroupSourcesCommand, _super);
    function DeregisterTransitGatewayMulticastGroupSourcesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeregisterTransitGatewayMulticastGroupSourcesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeregisterTransitGatewayMulticastGroupSourcesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeregisterTransitGatewayMulticastGroupSourcesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DeregisterTransitGatewayMulticastGroupSourcesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeregisterTransitGatewayMulticastGroupSourcesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeregisterTransitGatewayMulticastGroupSourcesCommand(input, context);
    };
    DeregisterTransitGatewayMulticastGroupSourcesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeregisterTransitGatewayMulticastGroupSourcesCommand(output, context);
    };
    return DeregisterTransitGatewayMulticastGroupSourcesCommand;
}($Command));
export { DeregisterTransitGatewayMulticastGroupSourcesCommand };
