import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeregisterTransitGatewayMulticastGroupMembersRequest, DeregisterTransitGatewayMulticastGroupMembersResult, } from "../models/models_2";
import { deserializeAws_ec2DeregisterTransitGatewayMulticastGroupMembersCommand, serializeAws_ec2DeregisterTransitGatewayMulticastGroupMembersCommand, } from "../protocols/Aws_ec2";
var DeregisterTransitGatewayMulticastGroupMembersCommand = (function (_super) {
    __extends(DeregisterTransitGatewayMulticastGroupMembersCommand, _super);
    function DeregisterTransitGatewayMulticastGroupMembersCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeregisterTransitGatewayMulticastGroupMembersCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeregisterTransitGatewayMulticastGroupMembersCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeregisterTransitGatewayMulticastGroupMembersRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DeregisterTransitGatewayMulticastGroupMembersResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeregisterTransitGatewayMulticastGroupMembersCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeregisterTransitGatewayMulticastGroupMembersCommand(input, context);
    };
    DeregisterTransitGatewayMulticastGroupMembersCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeregisterTransitGatewayMulticastGroupMembersCommand(output, context);
    };
    return DeregisterTransitGatewayMulticastGroupMembersCommand;
}($Command));
export { DeregisterTransitGatewayMulticastGroupMembersCommand };
