import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeprovisionPublicIpv4PoolCidrRequest, DeprovisionPublicIpv4PoolCidrResult } from "../models/models_2";
import { deserializeAws_ec2DeprovisionPublicIpv4PoolCidrCommand, serializeAws_ec2DeprovisionPublicIpv4PoolCidrCommand, } from "../protocols/Aws_ec2";
var DeprovisionPublicIpv4PoolCidrCommand = (function (_super) {
    __extends(DeprovisionPublicIpv4PoolCidrCommand, _super);
    function DeprovisionPublicIpv4PoolCidrCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeprovisionPublicIpv4PoolCidrCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeprovisionPublicIpv4PoolCidrCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeprovisionPublicIpv4PoolCidrRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DeprovisionPublicIpv4PoolCidrResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeprovisionPublicIpv4PoolCidrCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeprovisionPublicIpv4PoolCidrCommand(input, context);
    };
    DeprovisionPublicIpv4PoolCidrCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeprovisionPublicIpv4PoolCidrCommand(output, context);
    };
    return DeprovisionPublicIpv4PoolCidrCommand;
}($Command));
export { DeprovisionPublicIpv4PoolCidrCommand };
