import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteVpcEndpointServiceConfigurationsRequest, DeleteVpcEndpointServiceConfigurationsResult, } from "../models/models_2";
import { deserializeAws_ec2DeleteVpcEndpointServiceConfigurationsCommand, serializeAws_ec2DeleteVpcEndpointServiceConfigurationsCommand, } from "../protocols/Aws_ec2";
var DeleteVpcEndpointServiceConfigurationsCommand = (function (_super) {
    __extends(DeleteVpcEndpointServiceConfigurationsCommand, _super);
    function DeleteVpcEndpointServiceConfigurationsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteVpcEndpointServiceConfigurationsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteVpcEndpointServiceConfigurationsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteVpcEndpointServiceConfigurationsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DeleteVpcEndpointServiceConfigurationsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteVpcEndpointServiceConfigurationsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteVpcEndpointServiceConfigurationsCommand(input, context);
    };
    DeleteVpcEndpointServiceConfigurationsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteVpcEndpointServiceConfigurationsCommand(output, context);
    };
    return DeleteVpcEndpointServiceConfigurationsCommand;
}($Command));
export { DeleteVpcEndpointServiceConfigurationsCommand };
