import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteTransitGatewayPrefixListReferenceRequest, DeleteTransitGatewayPrefixListReferenceResult, } from "../models/models_2";
import { deserializeAws_ec2DeleteTransitGatewayPrefixListReferenceCommand, serializeAws_ec2DeleteTransitGatewayPrefixListReferenceCommand, } from "../protocols/Aws_ec2";
var DeleteTransitGatewayPrefixListReferenceCommand = (function (_super) {
    __extends(DeleteTransitGatewayPrefixListReferenceCommand, _super);
    function DeleteTransitGatewayPrefixListReferenceCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteTransitGatewayPrefixListReferenceCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteTransitGatewayPrefixListReferenceCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteTransitGatewayPrefixListReferenceRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DeleteTransitGatewayPrefixListReferenceResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteTransitGatewayPrefixListReferenceCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteTransitGatewayPrefixListReferenceCommand(input, context);
    };
    DeleteTransitGatewayPrefixListReferenceCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteTransitGatewayPrefixListReferenceCommand(output, context);
    };
    return DeleteTransitGatewayPrefixListReferenceCommand;
}($Command));
export { DeleteTransitGatewayPrefixListReferenceCommand };
