import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteTransitGatewayConnectRequest, DeleteTransitGatewayConnectResult } from "../models/models_2";
import { deserializeAws_ec2DeleteTransitGatewayConnectCommand, serializeAws_ec2DeleteTransitGatewayConnectCommand, } from "../protocols/Aws_ec2";
var DeleteTransitGatewayConnectCommand = (function (_super) {
    __extends(DeleteTransitGatewayConnectCommand, _super);
    function DeleteTransitGatewayConnectCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteTransitGatewayConnectCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteTransitGatewayConnectCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteTransitGatewayConnectRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DeleteTransitGatewayConnectResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteTransitGatewayConnectCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteTransitGatewayConnectCommand(input, context);
    };
    DeleteTransitGatewayConnectCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteTransitGatewayConnectCommand(output, context);
    };
    return DeleteTransitGatewayConnectCommand;
}($Command));
export { DeleteTransitGatewayConnectCommand };
