import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteSnapshotRequest } from "../models/models_2";
import { deserializeAws_ec2DeleteSnapshotCommand, serializeAws_ec2DeleteSnapshotCommand } from "../protocols/Aws_ec2";
var DeleteSnapshotCommand = (function (_super) {
    __extends(DeleteSnapshotCommand, _super);
    function DeleteSnapshotCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteSnapshotCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteSnapshotCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteSnapshotRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteSnapshotCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteSnapshotCommand(input, context);
    };
    DeleteSnapshotCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteSnapshotCommand(output, context);
    };
    return DeleteSnapshotCommand;
}($Command));
export { DeleteSnapshotCommand };
