import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteRouteTableRequest } from "../models/models_2";
import { deserializeAws_ec2DeleteRouteTableCommand, serializeAws_ec2DeleteRouteTableCommand, } from "../protocols/Aws_ec2";
var DeleteRouteTableCommand = (function (_super) {
    __extends(DeleteRouteTableCommand, _super);
    function DeleteRouteTableCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteRouteTableCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteRouteTableCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteRouteTableRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteRouteTableCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteRouteTableCommand(input, context);
    };
    DeleteRouteTableCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteRouteTableCommand(output, context);
    };
    return DeleteRouteTableCommand;
}($Command));
export { DeleteRouteTableCommand };
