import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeletePublicIpv4PoolRequest, DeletePublicIpv4PoolResult } from "../models/models_2";
import { deserializeAws_ec2DeletePublicIpv4PoolCommand, serializeAws_ec2DeletePublicIpv4PoolCommand, } from "../protocols/Aws_ec2";
var DeletePublicIpv4PoolCommand = (function (_super) {
    __extends(DeletePublicIpv4PoolCommand, _super);
    function DeletePublicIpv4PoolCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeletePublicIpv4PoolCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeletePublicIpv4PoolCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeletePublicIpv4PoolRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DeletePublicIpv4PoolResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeletePublicIpv4PoolCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeletePublicIpv4PoolCommand(input, context);
    };
    DeletePublicIpv4PoolCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeletePublicIpv4PoolCommand(output, context);
    };
    return DeletePublicIpv4PoolCommand;
}($Command));
export { DeletePublicIpv4PoolCommand };
