import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteNetworkInsightsAccessScopeAnalysisRequest, DeleteNetworkInsightsAccessScopeAnalysisResult, } from "../models/models_2";
import { deserializeAws_ec2DeleteNetworkInsightsAccessScopeAnalysisCommand, serializeAws_ec2DeleteNetworkInsightsAccessScopeAnalysisCommand, } from "../protocols/Aws_ec2";
var DeleteNetworkInsightsAccessScopeAnalysisCommand = (function (_super) {
    __extends(DeleteNetworkInsightsAccessScopeAnalysisCommand, _super);
    function DeleteNetworkInsightsAccessScopeAnalysisCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteNetworkInsightsAccessScopeAnalysisCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteNetworkInsightsAccessScopeAnalysisCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteNetworkInsightsAccessScopeAnalysisRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DeleteNetworkInsightsAccessScopeAnalysisResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteNetworkInsightsAccessScopeAnalysisCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteNetworkInsightsAccessScopeAnalysisCommand(input, context);
    };
    DeleteNetworkInsightsAccessScopeAnalysisCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteNetworkInsightsAccessScopeAnalysisCommand(output, context);
    };
    return DeleteNetworkInsightsAccessScopeAnalysisCommand;
}($Command));
export { DeleteNetworkInsightsAccessScopeAnalysisCommand };
