import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteLaunchTemplateRequest, DeleteLaunchTemplateResult } from "../models/models_2";
import { deserializeAws_ec2DeleteLaunchTemplateCommand, serializeAws_ec2DeleteLaunchTemplateCommand, } from "../protocols/Aws_ec2";
var DeleteLaunchTemplateCommand = (function (_super) {
    __extends(DeleteLaunchTemplateCommand, _super);
    function DeleteLaunchTemplateCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteLaunchTemplateCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteLaunchTemplateCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteLaunchTemplateRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DeleteLaunchTemplateResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteLaunchTemplateCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteLaunchTemplateCommand(input, context);
    };
    DeleteLaunchTemplateCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteLaunchTemplateCommand(output, context);
    };
    return DeleteLaunchTemplateCommand;
}($Command));
export { DeleteLaunchTemplateCommand };
