import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteIpamRequest, DeleteIpamResult } from "../models/models_2";
import { deserializeAws_ec2DeleteIpamCommand, serializeAws_ec2DeleteIpamCommand } from "../protocols/Aws_ec2";
var DeleteIpamCommand = (function (_super) {
    __extends(DeleteIpamCommand, _super);
    function DeleteIpamCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteIpamCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteIpamCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteIpamRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DeleteIpamResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteIpamCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteIpamCommand(input, context);
    };
    DeleteIpamCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteIpamCommand(output, context);
    };
    return DeleteIpamCommand;
}($Command));
export { DeleteIpamCommand };
