import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteInternetGatewayRequest } from "../models/models_2";
import { deserializeAws_ec2DeleteInternetGatewayCommand, serializeAws_ec2DeleteInternetGatewayCommand, } from "../protocols/Aws_ec2";
var DeleteInternetGatewayCommand = (function (_super) {
    __extends(DeleteInternetGatewayCommand, _super);
    function DeleteInternetGatewayCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteInternetGatewayCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteInternetGatewayCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteInternetGatewayRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteInternetGatewayCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteInternetGatewayCommand(input, context);
    };
    DeleteInternetGatewayCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteInternetGatewayCommand(output, context);
    };
    return DeleteInternetGatewayCommand;
}($Command));
export { DeleteInternetGatewayCommand };
