import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteDhcpOptionsRequest } from "../models/models_2";
import { deserializeAws_ec2DeleteDhcpOptionsCommand, serializeAws_ec2DeleteDhcpOptionsCommand, } from "../protocols/Aws_ec2";
var DeleteDhcpOptionsCommand = (function (_super) {
    __extends(DeleteDhcpOptionsCommand, _super);
    function DeleteDhcpOptionsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteDhcpOptionsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteDhcpOptionsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteDhcpOptionsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteDhcpOptionsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteDhcpOptionsCommand(input, context);
    };
    DeleteDhcpOptionsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteDhcpOptionsCommand(output, context);
    };
    return DeleteDhcpOptionsCommand;
}($Command));
export { DeleteDhcpOptionsCommand };
