import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteCarrierGatewayRequest, DeleteCarrierGatewayResult } from "../models/models_2";
import { deserializeAws_ec2DeleteCarrierGatewayCommand, serializeAws_ec2DeleteCarrierGatewayCommand, } from "../protocols/Aws_ec2";
var DeleteCarrierGatewayCommand = (function (_super) {
    __extends(DeleteCarrierGatewayCommand, _super);
    function DeleteCarrierGatewayCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteCarrierGatewayCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteCarrierGatewayCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteCarrierGatewayRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DeleteCarrierGatewayResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteCarrierGatewayCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteCarrierGatewayCommand(input, context);
    };
    DeleteCarrierGatewayCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteCarrierGatewayCommand(output, context);
    };
    return DeleteCarrierGatewayCommand;
}($Command));
export { DeleteCarrierGatewayCommand };
