import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateVpnGatewayRequest, CreateVpnGatewayResult } from "../models/models_2";
import { deserializeAws_ec2CreateVpnGatewayCommand, serializeAws_ec2CreateVpnGatewayCommand, } from "../protocols/Aws_ec2";
var CreateVpnGatewayCommand = (function (_super) {
    __extends(CreateVpnGatewayCommand, _super);
    function CreateVpnGatewayCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateVpnGatewayCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateVpnGatewayCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateVpnGatewayRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateVpnGatewayResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateVpnGatewayCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateVpnGatewayCommand(input, context);
    };
    CreateVpnGatewayCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateVpnGatewayCommand(output, context);
    };
    return CreateVpnGatewayCommand;
}($Command));
export { CreateVpnGatewayCommand };
