import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateVpnConnectionRequest, CreateVpnConnectionResult } from "../models/models_2";
import { deserializeAws_ec2CreateVpnConnectionCommand, serializeAws_ec2CreateVpnConnectionCommand, } from "../protocols/Aws_ec2";
var CreateVpnConnectionCommand = (function (_super) {
    __extends(CreateVpnConnectionCommand, _super);
    function CreateVpnConnectionCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateVpnConnectionCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateVpnConnectionCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateVpnConnectionRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateVpnConnectionResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateVpnConnectionCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateVpnConnectionCommand(input, context);
    };
    CreateVpnConnectionCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateVpnConnectionCommand(output, context);
    };
    return CreateVpnConnectionCommand;
}($Command));
export { CreateVpnConnectionCommand };
