import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateVpcPeeringConnectionRequest, CreateVpcPeeringConnectionResult } from "../models/models_2";
import { deserializeAws_ec2CreateVpcPeeringConnectionCommand, serializeAws_ec2CreateVpcPeeringConnectionCommand, } from "../protocols/Aws_ec2";
var CreateVpcPeeringConnectionCommand = (function (_super) {
    __extends(CreateVpcPeeringConnectionCommand, _super);
    function CreateVpcPeeringConnectionCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateVpcPeeringConnectionCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateVpcPeeringConnectionCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateVpcPeeringConnectionRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateVpcPeeringConnectionResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateVpcPeeringConnectionCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateVpcPeeringConnectionCommand(input, context);
    };
    CreateVpcPeeringConnectionCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateVpcPeeringConnectionCommand(output, context);
    };
    return CreateVpcPeeringConnectionCommand;
}($Command));
export { CreateVpcPeeringConnectionCommand };
