import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateVpcEndpointConnectionNotificationRequest, CreateVpcEndpointConnectionNotificationResult, } from "../models/models_2";
import { deserializeAws_ec2CreateVpcEndpointConnectionNotificationCommand, serializeAws_ec2CreateVpcEndpointConnectionNotificationCommand, } from "../protocols/Aws_ec2";
var CreateVpcEndpointConnectionNotificationCommand = (function (_super) {
    __extends(CreateVpcEndpointConnectionNotificationCommand, _super);
    function CreateVpcEndpointConnectionNotificationCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateVpcEndpointConnectionNotificationCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateVpcEndpointConnectionNotificationCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateVpcEndpointConnectionNotificationRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateVpcEndpointConnectionNotificationResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateVpcEndpointConnectionNotificationCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateVpcEndpointConnectionNotificationCommand(input, context);
    };
    CreateVpcEndpointConnectionNotificationCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateVpcEndpointConnectionNotificationCommand(output, context);
    };
    return CreateVpcEndpointConnectionNotificationCommand;
}($Command));
export { CreateVpcEndpointConnectionNotificationCommand };
