import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateTransitGatewayVpcAttachmentRequest, CreateTransitGatewayVpcAttachmentResult } from "../models/models_2";
import { deserializeAws_ec2CreateTransitGatewayVpcAttachmentCommand, serializeAws_ec2CreateTransitGatewayVpcAttachmentCommand, } from "../protocols/Aws_ec2";
var CreateTransitGatewayVpcAttachmentCommand = (function (_super) {
    __extends(CreateTransitGatewayVpcAttachmentCommand, _super);
    function CreateTransitGatewayVpcAttachmentCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateTransitGatewayVpcAttachmentCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateTransitGatewayVpcAttachmentCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateTransitGatewayVpcAttachmentRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateTransitGatewayVpcAttachmentResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateTransitGatewayVpcAttachmentCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateTransitGatewayVpcAttachmentCommand(input, context);
    };
    CreateTransitGatewayVpcAttachmentCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateTransitGatewayVpcAttachmentCommand(output, context);
    };
    return CreateTransitGatewayVpcAttachmentCommand;
}($Command));
export { CreateTransitGatewayVpcAttachmentCommand };
