import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateTransitGatewayConnectRequest, CreateTransitGatewayConnectResult } from "../models/models_1";
import { deserializeAws_ec2CreateTransitGatewayConnectCommand, serializeAws_ec2CreateTransitGatewayConnectCommand, } from "../protocols/Aws_ec2";
var CreateTransitGatewayConnectCommand = (function (_super) {
    __extends(CreateTransitGatewayConnectCommand, _super);
    function CreateTransitGatewayConnectCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateTransitGatewayConnectCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateTransitGatewayConnectCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateTransitGatewayConnectRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateTransitGatewayConnectResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateTransitGatewayConnectCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateTransitGatewayConnectCommand(input, context);
    };
    CreateTransitGatewayConnectCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateTransitGatewayConnectCommand(output, context);
    };
    return CreateTransitGatewayConnectCommand;
}($Command));
export { CreateTransitGatewayConnectCommand };
