import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateTransitGatewayRequest, CreateTransitGatewayResult } from "../models/models_1";
import { deserializeAws_ec2CreateTransitGatewayCommand, serializeAws_ec2CreateTransitGatewayCommand, } from "../protocols/Aws_ec2";
var CreateTransitGatewayCommand = (function (_super) {
    __extends(CreateTransitGatewayCommand, _super);
    function CreateTransitGatewayCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateTransitGatewayCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateTransitGatewayCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateTransitGatewayRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateTransitGatewayResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateTransitGatewayCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateTransitGatewayCommand(input, context);
    };
    CreateTransitGatewayCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateTransitGatewayCommand(output, context);
    };
    return CreateTransitGatewayCommand;
}($Command));
export { CreateTransitGatewayCommand };
