import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateTrafficMirrorFilterRequest, CreateTrafficMirrorFilterResult } from "../models/models_1";
import { deserializeAws_ec2CreateTrafficMirrorFilterCommand, serializeAws_ec2CreateTrafficMirrorFilterCommand, } from "../protocols/Aws_ec2";
var CreateTrafficMirrorFilterCommand = (function (_super) {
    __extends(CreateTrafficMirrorFilterCommand, _super);
    function CreateTrafficMirrorFilterCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateTrafficMirrorFilterCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateTrafficMirrorFilterCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateTrafficMirrorFilterRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateTrafficMirrorFilterResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateTrafficMirrorFilterCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateTrafficMirrorFilterCommand(input, context);
    };
    CreateTrafficMirrorFilterCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateTrafficMirrorFilterCommand(output, context);
    };
    return CreateTrafficMirrorFilterCommand;
}($Command));
export { CreateTrafficMirrorFilterCommand };
