import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateSubnetRequest, CreateSubnetResult } from "../models/models_1";
import { deserializeAws_ec2CreateSubnetCommand, serializeAws_ec2CreateSubnetCommand } from "../protocols/Aws_ec2";
var CreateSubnetCommand = (function (_super) {
    __extends(CreateSubnetCommand, _super);
    function CreateSubnetCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateSubnetCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateSubnetCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateSubnetRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateSubnetResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateSubnetCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateSubnetCommand(input, context);
    };
    CreateSubnetCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateSubnetCommand(output, context);
    };
    return CreateSubnetCommand;
}($Command));
export { CreateSubnetCommand };
