import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateSnapshotsRequest, CreateSnapshotsResult } from "../models/models_1";
import { deserializeAws_ec2CreateSnapshotsCommand, serializeAws_ec2CreateSnapshotsCommand } from "../protocols/Aws_ec2";
var CreateSnapshotsCommand = (function (_super) {
    __extends(CreateSnapshotsCommand, _super);
    function CreateSnapshotsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateSnapshotsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateSnapshotsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateSnapshotsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateSnapshotsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateSnapshotsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateSnapshotsCommand(input, context);
    };
    CreateSnapshotsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateSnapshotsCommand(output, context);
    };
    return CreateSnapshotsCommand;
}($Command));
export { CreateSnapshotsCommand };
