import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateSnapshotRequest, Snapshot } from "../models/models_1";
import { deserializeAws_ec2CreateSnapshotCommand, serializeAws_ec2CreateSnapshotCommand } from "../protocols/Aws_ec2";
var CreateSnapshotCommand = (function (_super) {
    __extends(CreateSnapshotCommand, _super);
    function CreateSnapshotCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateSnapshotCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateSnapshotCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateSnapshotRequest.filterSensitiveLog,
            outputFilterSensitiveLog: Snapshot.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateSnapshotCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateSnapshotCommand(input, context);
    };
    CreateSnapshotCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateSnapshotCommand(output, context);
    };
    return CreateSnapshotCommand;
}($Command));
export { CreateSnapshotCommand };
